<?php
class UsersAdmin
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
  }
  function getQuerySingleResult($query)
  {
    //Brak obiektu $dbo
    if(!$this->dbo) return false;
    
    //Wykonanie zapytania.
    if(!$result = $this->dbo->query($query)){
      //echo 'Wystpi bd (getQuerySingleResult): nieprawidowe zapytanie...';
      return false;
    }
    if($row = $result->fetch_row()){
      //Zwrcenie wyniku.
      return $row[0];
    }
    else{
      //Brak wynikw zapytania.
      return false;
    }
  }
  function getPagination($page, $pages, $link, $msg)
  {
    $str = '';
    for($i = 0; $i < $pages; $i++){
      if($i != $page){
        $str .= "<a href=\"$link&amp;page=$i\">".($i+1)."</a>";
      }
      else{
        $str .= '<span class="activePaginationPage">' . ($i+1)
              . '</span>';
      }
      $str .= '<span class="space"> </span>';
    }
    $str = $msg . $str;
    return $str;
  }
  function showList($limit)
  {
    if(!$this->dbo){
      echo 'Lista uytkownikw nie jest dostpna.';
      return;
    }
    
    //Odczytanie parametru page.
    if(isset($_GET['page'])){
      $page = intval($_GET['page']);
    }
    else{
      $page = 0;
    }
    
    //Okrelenie cakowitej liczby wierszy w tabeli Users.
    $query = "SELECT COUNT(*) FROM Users";
    $rowsCount = intval($this->getQuerySingleResult($query));
    
    //Obliczenie cakowitej liczby stron z wynikami
    $pages = ceil($rowsCount / $limit);
    
    if($page < 0 || $page >= $pages) $page = 0;
    
    $offset = $page * $limit;
    
    //Zapytanie pobierajce wyniki dla biecej strony.
    $query = "SELECT Id, Nazwa, Imie, Nazwisko, Email ";
    $query .= "FROM Users LIMIT $offset, $limit";

    if(!$result = $this->dbo->query($query)){
      return;
    }
    ?>
    <div id="usersListDiv">
    <table>
    <?php
    //Odczytanie wynikw zapytania i umieszczenie ich w tabeli HTML.
    while($row = $result->fetch_row()){
      echo '<tr>';
      foreach($row as $val){
        echo "<td>$val</td>";
      }
      echo '<td>';
      echo '<a href="index.php?action=usersAdmin&amp;wtd=showEditForm&amp;id=';
      echo $row[0] . '">Edytuj</a>';
      echo '<td>';
      echo '<a href="index.php?action=usersAdmin&amp;wtd=deleteUser&amp;id=';
      echo $row[0] . '">Usu</a>';
      echo '</tr>';
    }
    ?>
    </table>
    <div id="paginationDiv">
    <?php echo $this->getPagination($page, $pages, 
                      'index.php?action=usersAdmin&amp;wtd=ShowList',
                      'Id do strony: ');
    ?>
    </div>
    </div>
    <?php
  }
  function showEditForm($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Edycja istniejcego konta.
    if($action == 'edit'){
      //Sprawdzenie czy istnieje parametr id.
      if(!isset($_GET['id'])){
        echo 'Brak parametru id.';
        return FORM_DATA_MISSING;
      }
      
      //Sprawdzenie poprawnoci parametru id.
      if(($id = intval($_GET['id'])) < 1){
        echo 'Nieprawidowy parametr id.';
        return INVALID_USER_ID;
      }
      
      //Zapytanie pobierajce dane.
      $query = "SELECT * FROM Users WHERE id=$id";
      
      if(!$result = $this->dbo->query($query)){
        echo 'Bd serwera. Niewaciwe zapytanie MySQL.';
        return SERVER_ERROR;
      }
      if(!$row = $result->fetch_row()){
        echo 'Nieprawidowy parametr id.';
        return INVALID_USER_ID;
      }
      
      //Ustawienie wartoci zmiennych uywanych w formularzu.
      $id = $row[0];
      $nazwa = $row[1];
      $imie = $row[3];
      $nazwisko = $row[4];
      $email = $row[5];
      
      $wtd = 'modifyUser';
      $readonly = 'readonly="true"';
    }
    //Dodawanie nowego konta.
    else{
      $id = '';
      $nazwa = '';
      $imie = '';
      $nazwisko = '';
      $email = '';
      $wtd = 'addUser';
      $readonly = '';
    }
    include 'editUserForm.php';
  }
  function editUser($action)
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostay przekazane dane.
    if(!isset($_POST['id']) || !isset($_POST['nazwa']) || 
       !isset($_POST['imie']) || !isset($_POST['nazwisko']) || 
       !isset($_POST['email']) || !isset($_POST['haslo'])){
      return FORM_DATA_MISSING;
    }
    
    //Zapis danych w zmiennych pomocniczych.
    $id = intval($_POST['id']);
    $nazwa = $_POST['nazwa'];
    $haslo = $_POST['haslo'];
    $imie = $_POST['imie'];
    $nazwisko = $_POST['nazwisko'];
    $email = $_POST['email'];
    
    //Sprawdzenie poprawnoci danych.
    if(($action == 'edit' && $id < 1) ||
       ($action == 'add' && $id < 0)) return INVALID_USER_ID;
    
    if(!preg_match("/^[a-zA-Z0-9_.]{3,20}$/", $nazwa)){
      return INVALID_USER_NAME;
    };
    
    /*
      Tutaj dalsze instrukcje weryfikujce dane.
    */
    
    //Zabezpieczenie znakw specjalnych w parametrach.
    $nazwa = $this->dbo->real_escape_string($nazwa);
    $imie = $this->dbo->real_escape_string($imie);
    $nazwisko = $this->dbo->real_escape_string($nazwisko);
    $email = $this->dbo->real_escape_string($email);
    
    if($action == 'edit'){
      //Kodowanie hasa.
      if($haslo != ''){
        $pass = "Haslo='".crypt($haslo)."', ";
      }
      else{
        $pass = '';
      }
      $query = "UPDATE Users SET Nazwa='$nazwa', Imie='$imie', $pass";
      $query .= "Nazwisko='$nazwisko', Email='$email' WHERE id=$id ";
    }
    else{
      //Sprawdzenie czy istnieje uytkownik o podanej nazwie.
      $query = "SELECT id FROM Users WHERE Nazwa='$nazwa'";
      if($this->getQuerySingleResult($query) !== false){
        return USER_NAME_ALREADY_EXISTS;
      }
      //Sprawdzenie czy istnieje uytkownik o podanym id.
      if($id > 0){
        $query = "SELECT id FROM Users WHERE id=$id";
        if($this->getQuerySingleResult($query) !== false){
          return USER_ID_ALREADY_EXISTS;
        }
      }
      
      //Kodowanie hasa.
      $haslo = crypt($haslo);
      
      $query = "INSERT INTO Users VALUES($id, '$nazwa', '$haslo', ";
      $query .= "'$imie', '$nazwisko', '$email')";
    }
    
    if($this->dbo->query($query)){
      return ACTION_OK;
    }
    else{
      return ACTION_FAILED;
    }
  }
  function showSearchForm()
  {
    include 'searchUserForm.php';
  }
  function searchUser()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie czy zostay przekazane dane.
    if(!isset($_POST['id']) || !isset($_POST['nazwa']))
      return FORM_DATA_MISSING;
    
    $id = $_POST['id'];
    $nazwa = $_POST['nazwa'];
    
    if($id == '' && $nazwa == '')
      return FORM_DATA_MISSING;
    
    //Ustalenie warunku dla identyfikatora.
    if($id != ''){
      if(intval($id) < 1) return INVALID_USER_ID;
      $cond1 = " AND id=$id ";
    }
    else{
      $cond1 = '';
    }
    
    //Ustalenie warunku dla nazwy.
    if($nazwa != ''){
      if(!preg_match("/^[a-zA-Z0-9_.]{3,20}$/", $nazwa)){
        return INVALID_USER_NAME;
      };
      $nazwa = $this->dbo->real_escape_string($nazwa);
      $cond2 = " AND nazwa='$nazwa' ";
    }
    else{
      $cond2 = '';
    }
    
    //Zapytanie pobierajce dane.
    $query = 'SELECT * FROM Users WHERE 1=1 '.$cond1.$cond2;
    if(!$result = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    if(!$row = $result->fetch_row()){
      return USER_NOT_FOUND;
    }
    
    //Ustalenie stanu zmiennych dla formularza edycji danych.
    $id = $row[0];
    $nazwa = $row[1];
    $imie = $row[3];
    $nazwisko = $row[4];
    $email = $row[5];
    
    $readonly = '';
    $wtd = 'modifyUser';
    
    //Doczenie formularza i powrt.
    include 'editUserForm.php';
    return ACTION_OK;
  }
  function deleteUser()
  {
    if(!$this->dbo) return SERVER_ERROR;
    
    //Sprawdzenie poprawnoci parametru id.
    if(!isset($_GET['id']) || intval($_GET['id']) < 1){
      return INVALID_USER_ID;
    }
    
    //Formowanie zapytania SQL.
    $id = intval($_GET['id']);
    $query = "DELETE FROM Users WHERE id = $id";
    
    if(!$this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Rezultat dziaania metody.
    if($this->dbo->affected_rows == 0){
      return USER_NOT_FOUND;
    }
    else{
      return ACTION_OK;
    }
  }
}
?>